
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD.View
{
    public class Unit : PI.FM.N000.Base.BL.DBD.BaseTable<BO.View.Unit>
    {
        #region Static factory
        private static Unit _factory = null;

        public static Unit DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Unit();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_UnitView";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Title", "Title"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("ISO639_3", "ISO639_3"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("BranchID", "BranchID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("SubjectID", "SubjectID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("DifficultyID", "DifficultyID"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsActive", "IsActive"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsStatistic", "IsStatistic"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Flags", "Flags"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("ExerciseTotal", "ExerciseTotal"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("ExerciseDone", "ExerciseDone"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("ExerciseMaxPointDone", "ExerciseMaxPointDone"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch  : return new Command_RestoreBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.View.Unit>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.View.Unit.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ContextObjectID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CourseID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ExerciseDifficultyID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_UnitView_RestoreBySearch";
            }
        }
        #endregion

    }
}